/*
 *	Model class
 */
function Model()
{
	this.vertices	= []
	this.faces		= []
	this.colors		= []

	this.backFaceCulling	= true;
	this.position	= {x:0,y:0,z:0}
	this.angle		= {x:0,y:0,z:0}



	/*
	 *	drawTriangle
	 */
	this.drawTriangle = function( c, p, colorOffset )
	{
		var	colorOffset = colorOffset||0;
			fillStyle = typeof( p.color )!='string'?this.colors[ p.color+colorOffset ]:p.color;

		if( c.fillStyle!=fillStyle )c.fillStyle = c.strokeStyle = fillStyle;

		c.beginPath();
			c.moveTo( this.vertices[ p.a ].xs, this.vertices[ p.a ].ys )
			c.lineTo( this.vertices[ p.b ].xs, this.vertices[ p.b ].ys )
			c.lineTo( this.vertices[ p.c ].xs, this.vertices[ p.c ].ys )
			if( p.d!=undefined )
				c.lineTo( this.vertices[ p.d ].xs, this.vertices[ p.d ].ys )
			if( p.e!=undefined )
				c.lineTo( this.vertices[ p.e ].xs, this.vertices[ p.e ].ys )
		c.closePath();
//		c.stroke();
		c.fill();
	}


	this.computeRotationMatrix = function( angle, translation )
	{
		var	cx	= Math.cos(angle.x),
		    sx	= Math.sin(angle.x),
		    cy	= Math.cos(angle.y),
		    sy	= Math.sin(angle.y),
		    cz	= Math.cos(angle.z),
		    sz	= Math.sin(angle.z)

			M	= [
	         	cy*cz,
	         	-cy*sz,
	         	sy,
	         	sx*sy*cz+cx*sz,
	         	-sx*sy*sz+cx*cz,
	         	-sx*cy,
	         	-cx*sy*cz+sx*sz,
	         	cx*sy*sz+sx*cz,
	         	cx*cy
			]

		M.push(
			0*(translation.x*M[0]+translation.y*M[1]+translation.z*M[2])-translation.x,
			0*(translation.x*M[3]+translation.y*M[4]+translation.z*M[5])-translation.y,
			0*(translation.x*M[6]+translation.y*M[7]+translation.z*M[8])-translation.z
		)
		return M
	}

	this.computeTransposedRotationMatrix = function( angle, translation )
	{
		var	cx	= Math.cos(angle.x),
		    sx	= Math.sin(angle.x),
		    cy	= Math.cos(angle.y),
		    sy	= Math.sin(angle.y),
		    cz	= Math.cos(angle.z),
		    sz	= Math.sin(angle.z),
			M	= [
				cy*cz,
				sx*sy*cz+cx*sz,
				-cx*sy*cz+sx*sz,
				-cy*sz,
				-sx*sy*sz+cx*cz,
				cx*sy*sz+sx*cz,
				sy,
				-sx*cy,
				cx*cy
			]

		M.push(
			0*(translation.x*M[0]+translation.y*M[1]+translation.z*M[2])-translation.x,
			0*(translation.x*M[3]+translation.y*M[4]+translation.z*M[5])-translation.y,
			0*(translation.x*M[6]+translation.y*M[7]+translation.z*M[8])-translation.z
		)
		return M
	}



	/*
	 *	rotateAndProject
	 */
	this.rotateAndProject = function( angle, camera, cx, cy, fovAngle, transformFunction, transformFunctionArgument )
	{
//		var M = this.computeTransposedRotationMatrix( angle, camera )
		var M = this.computeRotationMatrix( angle, camera )

		var transformFunction=transformFunction||function(a){return a}

		px = this.position.x
		py = this.position.y
		pz = this.position.z

		camera_x = camera.x //	camera.x*m1+camera.y*m2+camera.z*m3-camera.x
        camera_y = camera.y //	camera.x*m4+camera.y*m5+camera.z*m6-camera.y
        camera_z = camera.z //	camera.x*m7+camera.y*m8+camera.z*m9-camera.z


		var fovRatio = cx / Math.tan( fovAngle )
		for( var i=0, p; p=this.vertices[i]; i++ )
		{
			var pt	= transformFunction( p, transformFunctionArgument, i ),
				x = pt.x-px
				y = pt.y-py
				z = pt.z-pz

			p.zr = Math.max( 0, x*M[6]+y*M[7]+z*M[8]	+M[11] )
			if( p.zr )
			{
				p.xr = x*M[0]+y*M[1]+z*M[2]	+M[9]
				p.yr = x*M[3]+y*M[4]+z*M[5]	+M[10]

				var	fov = fovRatio/p.zr
				p.xs = cx+p.xr*fov
				p.ys = cy-p.yr*fov
			}
		}
	}


	/*
	 *	sortFaces
	 */
	this.sortFaces = function()
	{
		var zNear = this.zNear||.1

		for( var i=0,p; p=this.faces[i]; i++ )
		{
			var aZr = this.vertices[p.a].zr,
				bZr = this.vertices[p.b].zr,
				cZr = this.vertices[p.c].zr,
				dZr = p.d==undefined?cZr:this.vertices[p.d].zr,
				eZr = p.e==undefined?cZr:this.vertices[p.e].zr

			if( aZr>zNear && bZr>zNear && cZr>zNear && dZr>zNear && eZr>zNear )
			{
				var a = this.vertices[p.a],
					b = this.vertices[p.b],
					c = this.vertices[p.c]

				this.faces[i].zr = Math.max( aZr, bZr, cZr, dZr, eZr )
				this.faces[i].zn = c.xr*((aZr*b.yr)-(a.yr*bZr))+c.yr*((a.xr*bZr)-(aZr*b.xr))+cZr*((a.yr*b.xr)-(a.xr*b.yr))
			}
			else
				this.faces[i].zr = 0
		}

		this.faces.sort( function( p1, p2 )
		{
			return p2.zr-p1.zr
		} )
	}

	/*
	 *
	 */
	 this.drawTriangles = function( outputCanvasContext )
	 {
		for( var i=0,p; p=this.faces[i]; i++ )
			if( p.zr && p.zn>0 )
				this.drawTriangle( outputCanvasContext, p )
	}
}


function Cube( side, x, y, z, colorsArray )
{
	// extend object
	this.parent = Model
	this.parent()


	this.vertices.push(
		{ x:-side,	y:-side,	z:-side },
		{ x: side,	y:-side,	z:-side },
		{ x: side,	y: side,	z:-side },
		{ x:-side,	y: side,	z:-side },
		{ x:-side,	y:-side,	z: side },
		{ x: side,	y:-side,	z: side },
		{ x: side,	y: side,	z: side },
		{ x:-side,	y: side,	z: side }
	)
	this.faces.push(
		{	color:0, a:3, b:2, c:1, d:0 },
		{	color:1, a:4, b:5, c:6, d:7 },
		{	color:2, a:0, b:1, c:5, d:4 },
		{	color:3, a:2, b:3, c:7, d:6 },
		{	color:4, a:4, b:7, c:3, d:0 },
		{	color:5, a:1, b:2, c:6, d:5 }
	)


	this.position.x = x||0
	this.position.y = y||0
	this.position.z = z||0

	if( colorsArray!=undefined && colorsArray.constructor==Array )
		this.colors = colorsArray;
}
